/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWTableDefinition;
import filenet.vw.api.VWXMLHandler;
import java.io.Serializable;

public final class VWExposedFieldDefinition
extends VWMLABase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7504L;
    protected int type;
    protected int length = 0;
    protected String name;
    protected String prompt;
    protected boolean systemField = false;
    protected boolean bHasChanged = false;
    protected boolean mandatorySystemField = false;
    protected String sourceName;
    protected int sourceType;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:20:12 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/5 $";
    }

    protected VWExposedFieldDefinition(String theName, int theFieldType, int theLength, boolean isSystemField, String theSourceName, int theSourceType) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWExpFieldDefNullOrEmptyName", "Exposed field names cannot be null or empty.");
        }
        if (!VWFieldType.isValid(theFieldType)) {
            throw new VWException("vw.api.VWExpFieldDefInvalidFieldType", "theFieldType is not a valid field type value.");
        }
        if (theLength < 0) {
            throw new VWException("vw.api.VWExpFieldDefNotPositive", "The length must be positive.");
        }
        if (theSourceName == null || theSourceName.length() == 0) {
            throw new VWException("vw.api.VWExpFieldDefBadSourceName", "Exposed field source names cannot be null or empty.");
        }
        if (!VWTableDefinition.isValid(theSourceType)) {
            throw new VWException("vw.api.VWExpFieldDefInvalidSourceFieldType", "theSourceFieldType is not a valid source field type value: {0}.", Integer.toString(theSourceType));
        }
        this.name = theName;
        this.type = theFieldType;
        this.length = theLength;
        this.systemField = isSystemField;
        this.bHasChanged = false;
        this.sourceName = theSourceName;
        this.sourceType = theSourceType;
    }

    protected VWExposedFieldDefinition(String theName, int theFieldType, int theLength, boolean isSystemField, String theSourceName, int theSourceType, VWSession theSession) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWExpFieldDefNullOrEmptyName", "Exposed field names cannot be null or empty.");
        }
        if (!VWFieldType.isValid(theFieldType)) {
            throw new VWException("vw.api.VWExpFieldDefInvalidFieldType", "theFieldType is not a valid field type value.");
        }
        if (theLength < 0) {
            throw new VWException("vw.api.VWExpFieldDefNotPositive", "The length must be positive.");
        }
        if (theSourceName == null || theSourceName.length() == 0) {
            throw new VWException("vw.api.VWExpFieldDefBadSourceName", "Exposed field source names cannot be null or empty.");
        }
        if (!VWTableDefinition.isValid(theSourceType)) {
            throw new VWException("vw.api.VWExpFieldDefInvalidSourceFieldType", "theSourceFieldType is not a valid source field type value: {0}.", Integer.toString(theSourceType));
        }
        this.name = theName;
        this.type = theFieldType;
        this.length = theLength;
        this.systemField = isSystemField;
        this.bHasChanged = false;
        this.sourceName = theSourceName;
        this.sourceType = theSourceType;
        this.setSession(theSession);
    }

    public int getFieldType() {
        return this.type;
    }

    public int getLength() {
        if (this.getFieldType() == 2) {
            return this.length;
        }
        return 0;
    }

    protected int getRealLength() {
        return this.length;
    }

    public void setLength(int theLength) throws VWException {
        if (this.mandatorySystemField) {
            throw new VWException("vw.api.VWExposedFieldDefCantSetLength", "System fields cannot be changed.");
        }
        if (this.type != 2) {
            throw new VWException("vw.api.VWExposedFieldDefMustBeString", "Lengths may only be set for string types.");
        }
        if (theLength < 0) {
            throw new VWException("vw.api.VWExpFieldDefNotPositive", "The length must be positive.");
        }
        this.length = theLength;
        this.bHasChanged = true;
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public String toString() {
        return this.getName();
    }

    public String getAuthoredName() throws VWException {
        return this.translateToAuthored(this.name);
    }

    public boolean isSystemField() {
        return this.systemField;
    }

    protected void setSystemField(boolean theValue) {
        this.systemField = theValue;
    }

    public boolean isMandatorySystemField() {
        return this.mandatorySystemField;
    }

    protected void setMandatorySystemField(boolean theValue) {
        this.mandatorySystemField = theValue;
        if (this.mandatorySystemField) {
            this.systemField = true;
        }
    }

    public boolean hasChanged() {
        return this.bHasChanged;
    }

    protected void setHasChanged(boolean theNewValue) {
        this.bHasChanged = theNewValue;
    }

    public int getFieldSourceType() {
        return this.sourceType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    protected Object clone() {
        try {
            VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)super.clone();
            return fieldDef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWExposedFieldDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        theBuffer.append(INDENT_0 + "<" + "ExposedFieldDefinition" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.name) + "\"\n");
        theBuffer.append(INDENT_1 + "Type" + "=\"" + VWFieldType.typeToString(this.type) + "\"\n");
        theBuffer.append(INDENT_1 + "Length" + "=\"" + this.length + "\"\n");
        theBuffer.append(INDENT_1 + "SourceName" + "=\"" + VWXMLHandler.toXMLString(this.sourceName) + "\"\n");
        theBuffer.append(INDENT_1 + "SourceType" + "=\"" + this.sourceType + "\"\n");
        theBuffer.append(INDENT_1 + "IsSystemField" + "=\"" + this.systemField + "\"\n");
        theBuffer.append(INDENT_1 + "IsMandatorySystemField" + "=\"" + this.mandatorySystemField + "\"");
        theBuffer.append("/>\n");
    }

    public String getPrompt() {
        return this.translateStr(this.prompt);
    }

    public void setPrompt(String thePrompt) {
        this.prompt = thePrompt;
    }
}

